/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.security.MessageDigest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

class CopyFileFromURL
extends Thread {
    private final String url_string;
    private final String destination_path;
    private final boolean compare_md5s_first;
    private int connection_timeout_ms;
    private int read_timeout_ms;

    public CopyFileFromURL(String url_string, String destination_path, int connection_timeout_ms, int read_timeout_ms, boolean compare_md5s_first) {
        this.url_string = url_string;
        this.destination_path = destination_path;
        this.compare_md5s_first = compare_md5s_first;
        this.connection_timeout_ms = connection_timeout_ms;
        this.read_timeout_ms = read_timeout_ms;
    }

    public static boolean isFileDataIdentical(File file1, File file2) {
        if (!file1.exists() && !file2.exists()) {
            return true;
        }
        if (!file1.exists() || !file2.exists()) {
            return false;
        }
        if (file1.length() != file2.length()) {
            return false;
        }
        try {
            byte[] bytes1 = Files.readAllBytes(file1.toPath());
            byte[] bytes2 = Files.readAllBytes(file2.toPath());
            if (bytes1.length != bytes2.length) {
                return false;
            }
            for (int i2 = 0; i2 < bytes1.length; ++i2) {
                if (bytes1[i2] == bytes2[i2]) continue;
                return false;
            }
            return true;
        }
        catch (IOException e2) {
            return false;
        }
    }

    public static boolean overwriteFileIfNotSameAsTemp(File file, File temp_file) {
        if (!temp_file.exists()) {
            atv.setErrorMessage("overwriteFileIfNotSameAsTemp: temp_file does not exist");
            new Exception().printStackTrace();
            return false;
        }
        if (file.exists()) {
            if (CopyFileFromURL.isFileDataIdentical(file, temp_file)) {
                FileUtils.deleteQuietly((File)temp_file);
                return false;
            }
            FileUtils.deleteQuietly((File)file);
            if (file.exists()) {
                FileUtils.deleteQuietly((File)temp_file);
                return false;
            }
        }
        if (temp_file.renameTo(file)) {
            return true;
        }
        try {
            FileUtils.moveFile((File)temp_file, (File)file);
            return true;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            FileUtils.deleteQuietly((File)temp_file);
            return false;
        }
    }

    public static String getMD5(File file) {
        if (file != null && file.exists()) {
            try {
                FileInputStream fis = new FileInputStream(file);
                byte[] bytes = IOUtils.toByteArray((InputStream)fis);
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(bytes, 0, bytes.length);
                String md5_string = new BigInteger(1, md.digest()).toString(16);
                fis.close();
                return md5_string;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return null;
    }

    public static boolean areMD5sTheSame(String local_file_path, String remote_file_url) {
        File file = new File(local_file_path);
        if (file.exists()) {
            String md5_string = null;
            if (remote_file_url.startsWith("http://")) {
                md5_string = li.performGetRequest(FilenameUtils.getPath((String)remote_file_url) + "md5.php?f=" + FilenameUtils.getName((String)remote_file_url), 2000, 2000);
            } else if (remote_file_url.startsWith("file:/")) {
                md5_string = CopyFileFromURL.getMD5(new File(remote_file_url.substring("file:/".length())));
            }
            if (md5_string != null && md5_string.equals(CopyFileFromURL.getMD5(file))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void run() {
        if (this.compare_md5s_first && CopyFileFromURL.areMD5sTheSame(this.destination_path, this.url_string)) {
            if (atv.inDevMode()) {
                System.out.println("Skipping download of " + this.url_string + " (identical MD5)");
            }
            return;
        }
        String temp_path = this.destination_path + ".temp";
        if (CopyFileFromURL.copyFileFromURL(this.url_string, temp_path, this.connection_timeout_ms, this.read_timeout_ms)) {
            CopyFileFromURL.overwriteFileIfNotSameAsTemp(new File(this.destination_path), new File(temp_path));
        }
    }

    public static boolean copyFileFromURL(String url_string, String destination_path, int connection_timeout_ms, int read_timeout_ms) {
        try {
            URLConnection c2 = new URL(url_string).openConnection();
            c2.setConnectTimeout(connection_timeout_ms);
            c2.setReadTimeout(read_timeout_ms);
            ReadableByteChannel rbc = Channels.newChannel(c2.getInputStream());
            FileOutputStream fos = new FileOutputStream(destination_path);
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            fos.close();
            if (atv.inDevMode()) {
                System.out.println("Successfully downloaded " + url_string);
            }
            return true;
        }
        catch (Exception e2) {
            if (atv.inDevMode()) {
                System.out.println("copyFileFromURL(" + url_string + "): " + e2.toString());
            }
            return false;
        }
    }
}

